<#ftl strip_whitespace=true>
<#function xmlEscape text>
  <#return text?replace('&', '&amp;')
                ?replace('<', '&lt;')
                ?replace('>', '&gt;')
                ?replace('"', '&quot;')
                ?replace("'", '&apos;')>
</#function>
<#escape x as xmlEscape(x)>

<#if requestInfo.model == "Cloud_Softphone_Desktop">
  <#assign SIPTransport = profile.SIPTransportDesktop>
  <#assign OutboundProxyEnabled = profile.OutboundProxyEnabledDesktop>
  <#assign OutboundProxy = profile.OutboundProxyDesktop>
  <#assign SipTimerRegistrationExpiry = profile.SipTimerRegistrationExpiryDesktop>
  <#assign SubscriptionExpires = profile.SubscriptionExpiresDesktop>
  <#assign SdesOutgoing = profile.SdesOutgoingDesktop>
  <#assign SdesIncoming = profile.SdesIncomingDesktop>
<#elseif requestInfo.model == "Cloud_Softphone_Mobile">
  <#assign SIPTransport = profile.SIPTransportMobile>
  <#assign OutboundProxyEnabled = profile.OutboundProxyEnabledMobile>
  <#assign OutboundProxy = profile.OutboundProxyMobile>
  <#assign SipTimerRegistrationExpiry = profile.SipTimerRegistrationExpiryMobile>
  <#assign SubscriptionExpires = profile.SubscriptionExpiresMobile>
  <#assign SdesOutgoing = profile.SdesOutgoingMobile>
  <#assign SdesIncoming = profile.SdesIncomingMobile>
</#if>
<#assign isResidential = userData.businessGroupName == "" || userData.isResidential>
<#assign hasDisplayName = userData.displayName?length gt 0>

<provisioning success="true" version="20">
  <accounts>
    <defaults>
      <transport>${SIPTransport}</transport>
<#if OutboundProxyEnabled>
      <proxy>${OutboundProxy}</proxy>
<#else>
      <proxy></proxy>
</#if>
      <expires>${SipTimerRegistrationExpiry}</expires>
      <subscriptionExpires>${SubscriptionExpires}</subscriptionExpires>
      <allowDiversionHeader>${profile.DisplayRedirection?string('1', '0')}</allowDiversionHeader>
      <diversionHeaderToDisplay>${profile.WhichRedirectionToDisplay}</diversionHeaderToDisplay>
      <voiceMailNumber>${profile.VoicemailAccessCode}</voiceMailNumber>
<#if SIPTransport?contains("tls")>
  <#if SdesOutgoing == "enabled" || SdesOutgoing == "disabled" || SdesOutgoing == "required">
      <sdesOutgoing>${SdesOutgoing}</sdesOutgoing>
  </#if>
  <#if SdesIncoming == "enabled" || SdesIncoming == "disabled" || SdesIncoming == "required">
      <sdesIncoming>${SdesIncoming}</sdesIncoming>
  </#if>
</#if>
    </defaults>
    <account id="${userData.sipAuthID}">
<#if hasDisplayName>
      <title>${userData.displayName}</title>
</#if>
      <host>${userData.sipDomainName}</host>
      <username>${userData.sipAuthID}</username>
      <password>${userData.sipPassword}</password>
<#if isResidential>
      <linkupMessagingEnabled>0</linkupMessagingEnabled>
<#elseif profile.LinkupMessagingEnabled == "enabled">
      <linkupMessagingEnabled>1</linkupMessagingEnabled>
<#elseif profile.LinkupMessagingEnabled == "disabled">
      <linkupMessagingEnabled>0</linkupMessagingEnabled>
</#if>
<#if isResidential>
      <conferencingEnabled>0</conferencingEnabled>
<#elseif profile.LinkupConferencingEnabled== "enabled">
      <conferencingEnabled>1</conferencingEnabled>
<#elseif profile.LinkupConferencingEnabled == "disabled">
      <conferencingEnabled>0</conferencingEnabled>
</#if>
      <commportalToken>${userData.commportalPAT}</commportalToken>
    </account>
  </accounts>
  <prefKeys>
    <defaults>
<#if profile.SanitizeLogs == "enabled">
      <sanitizeLogs>1</sanitizeLogs>
<#elseif profile.SanitizeLogs == "disabled">
      <sanitizeLogs>0</sanitizeLogs>
</#if>
<#if profile.SipTrafficLogging == "enabled">
      <sipTrafficLogging>1</sipTrafficLogging>
<#elseif profile.SipTrafficLogging == "disabled">
      <sipTrafficLogging>0</sipTrafficLogging>
</#if>
    </defaults>
    <modifications>
    </modifications>
  </prefKeys>
<#if isResidential>
  <contactsEnabled>0</contactsEnabled>
<#else>
  <contactsEnabled>1</contactsEnabled>
</#if>
  <commportalToken>${userData.commportalPAT}</commportalToken>
</provisioning>
</#escape>