<#ftl strip_whitespace=true>
<#function xmlEscape text>
  <#return text?replace('&', '&amp;')
                ?replace('<', '&lt;')
                ?replace('>', '&gt;')
                ?replace('"', '&quot;')
                ?replace("'", '&apos;')>
</#function>
<#escape x as xmlEscape(x)>

<#if requestInfo.model == "Cloud_Softphone_Desktop">
  <#assign SIPTransport = profile.SIPTransportDesktop>
  <#assign OutboundProxyEnabled = profile.OutboundProxyEnabledDesktop>
  <#assign OutboundProxy = profile.OutboundProxyDesktop>
  <#assign SipTimerRegistrationExpiry = profile.SipTimerRegistrationExpiryDesktop>
<#elseif requestInfo.model == "Cloud_Softphone_Mobile">
  <#assign SIPTransport = profile.SIPTransportMobile>
  <#assign OutboundProxyEnabled = profile.OutboundProxyEnabledMobile>
  <#assign OutboundProxy = profile.OutboundProxyMobile>
  <#assign SipTimerRegistrationExpiry = profile.SipTimerRegistrationExpiryMobile>
</#if>
<#assign isResidential = userData.businessGroupName == "" || userData.isResidential>

<provisioning success="true" version="19">
  <accounts>
    <defaults>
      <transport>${SIPTransport}</transport>
<#if OutboundProxyEnabled>
      <proxy>${OutboundProxy}</proxy>
<#else>
      <proxy></proxy>
</#if>
      <expires>${SipTimerRegistrationExpiry}</expires>
      <allowDiversionHeader>${profile.DisplayRedirection?string('1', '0')}</allowDiversionHeader>
      <diversionHeaderToDisplay>${profile.WhichRedirectionToDisplay}</diversionHeaderToDisplay>
      <voiceMailNumber>${profile.VoicemailAccessCode}</voiceMailNumber>
    </defaults>
    <account id="${userData.sipAuthID}">
      <host>${userData.sipDomainName}</host>
      <username>${userData.sipAuthID}</username>
      <password>${userData.sipPassword}</password>
<#if isResidential>
      <conferencingEnabled>0</conferencingEnabled>
      <linkupMessagingEnabled>0</linkupMessagingEnabled>
<#else>
      <networkId>${userData.businessGroupName}</networkId>
</#if>
      <commportalToken>${userData.commportalPAT}</commportalToken>
    </account>
  </accounts>
  <prefKeys>
    <defaults>
    </defaults>
    <modifications>
    </modifications>
  </prefKeys>
<#if isResidential>
  <contactsEnabled>0</contactsEnabled>
<#else>
  <contactsEnabled>1</contactsEnabled>
</#if>
  <commportalToken>${userData.commportalPAT}</commportalToken>
</provisioning>
</#escape>