      <#ftl strip_whitespace=true>
      <#function xmlEscape text>
      <#return text?replace('&', '&amp;')
                  ?replace('<', '&lt;')
                  ?replace('>', '&gt;')
                  ?replace('"', '&quot;')
                  ?replace("'", '&apos;')>
      </#function>
      <#escape x as xmlEscape(x)>
      <#if requestInfo.model == "Cloud_Softphone_Desktop">
      <#assign SIPTransport = profile.SIPTransportDesktop>
      <#assign OutboundProxyEnabled = profile.OutboundProxyEnabledDesktop>
      <#assign OutboundProxy = profile.OutboundProxyDesktop>
      <#assign SipTimerRegistrationExpiry = profile.SipTimerRegistrationExpiryDesktop>
      <#assign SubscriptionExpires = profile.SubscriptionExpiresDesktop>
      <#assign SdesOutgoing = profile.SdesOutgoingDesktop>
      <#assign SdesIncoming = profile.SdesIncomingDesktop>
      <#elseif requestInfo.model == "Cloud_Softphone_Mobile">
      <#assign SIPTransport = profile.SIPTransportMobile>
      <#assign OutboundProxyEnabled = profile.OutboundProxyEnabledMobile>
      <#assign OutboundProxy = profile.OutboundProxyMobile>
      <#assign SipTimerRegistrationExpiry = profile.SipTimerRegistrationExpiryMobile>
      <#assign SubscriptionExpires = profile.SubscriptionExpiresMobile>
      <#assign SdesOutgoing = profile.SdesOutgoingMobile>
      <#assign SdesIncoming = profile.SdesIncomingMobile>
      </#if>
      <#assign isResidential = userData.businessGroupName == "" || userData.isResidential>
      <#assign hasDisplayName = userData.displayName?length gt 0>

      <provisioning success="true" version="26">
      <accounts>
      <defaults>
            <transport>${SIPTransport}</transport>
      <#if OutboundProxyEnabled>
            <proxy>${OutboundProxy}</proxy>
      <#else>
            <proxy></proxy>
      </#if>
            <expires>${SipTimerRegistrationExpiry}</expires>
            <subscriptionExpires>${SubscriptionExpires}</subscriptionExpires>
            <allowDiversionHeader>${profile.DisplayRedirection?string('1', '0')}</allowDiversionHeader>
            <diversionHeaderToDisplay>${profile.WhichRedirectionToDisplay}</diversionHeaderToDisplay>
            <voiceMailNumber>${profile.VoicemailAccessCode}</voiceMailNumber>
      <#if SIPTransport?contains("tls")>
      <#if SdesOutgoing == "enabled" || SdesOutgoing == "disabled" || SdesOutgoing == "required">
            <sdesOutgoing>${SdesOutgoing}</sdesOutgoing>
      </#if>
      <#if SdesIncoming == "enabled" || SdesIncoming == "disabled" || SdesIncoming == "required">
            <sdesIncoming>${SdesIncoming}</sdesIncoming>
      </#if>
      </#if>
      </defaults>
      <account id="${userData.sipAuthID}">
      <#if hasDisplayName>
            <title>${userData.displayName}</title>
            <userDisplayName>${userData.displayName}</userDisplayName>
      </#if>
            <host>${userData.sipDomainName}</host>
            <#-- Check if sipAuthID contains a domain (has @) and use sipUsername + authUsername if it does -->
            <#if userData.sipAuthID?contains("@")>
            <username>${userData.sipUsername}</username>
            <authUsername>${userData.sipAuthID}</authUsername>
            <#else>
            <username>${userData.sipAuthID}</username>
            </#if>
            <password>${userData.sipPassword}</password>
      <#if !isResidential>
            <networkId>${userData.businessGroupName}</networkId>
      </#if>
      <#if isResidential>
            <linkupMessagingEnabled>0</linkupMessagingEnabled>
      <#elseif profile.LinkupMessagingEnabled == "enabled">
            <linkupMessagingEnabled>1</linkupMessagingEnabled>
      <#elseif profile.LinkupMessagingEnabled == "disabled">
            <linkupMessagingEnabled>0</linkupMessagingEnabled>
      </#if>
      <#if profile.VideoCallsEnabled == "enabled">
            <allowVideo>1</allowVideo>
      <#elseif profile.VideoCallsEnabled == "disabled">
            <allowVideo>0</allowVideo>
      </#if>
      <#if isResidential>
            <conferencingEnabled>0</conferencingEnabled>
      <#elseif profile.LinkupConferencingEnabled== "enabled">
            <conferencingEnabled>1</conferencingEnabled>
      <#elseif profile.LinkupConferencingEnabled == "disabled">
            <conferencingEnabled>0</conferencingEnabled>
      </#if>
            <commportalToken>${userData.commportalPAT}</commportalToken>
      <#assign smsNumbersList = []>
      <#list 0..3 as i>
        <#assign smsNumber = profile.SMSNumber[i]!"">
        <#if smsNumber?has_content && profile.SMSEnabled[i]?? && profile.SMSEnabled[i]>
          <#assign smsCarrier = profile.SMSCarrier[i]!"">
          <#assign smsLabel = profile.SMSLabel[i]!"">
          <#assign smsNumbersList = smsNumbersList + [{"number": smsNumber, "carrier": smsCarrier, "label": smsLabel}]>
        </#if>
      </#list>
      <#if smsNumbersList?has_content>
            <smsNumbers>
              <#list smsNumbersList as sms>
                <number>
                    <carrier>${sms.carrier}</carrier>
                    <number>${sms.number}</number>
                    <#if sms.label?has_content>
                    <label>${sms.label}</label>
                    </#if>
                </number>
              </#list>
            </smsNumbers>
      </#if>
      </account>
      </accounts>
      <prefKeys>
      <defaults>
      <#if profile.SanitizeLogs == "enabled">
            <sanitizeLogs>1</sanitizeLogs>
      <#elseif profile.SanitizeLogs == "disabled">
            <sanitizeLogs>0</sanitizeLogs>
      </#if>
      <#if profile.SipTrafficLogging == "enabled">
            <sipTrafficLogging>1</sipTrafficLogging>
      <#elseif profile.SipTrafficLogging == "disabled">
            <sipTrafficLogging>0</sipTrafficLogging>
      </#if>
      </defaults>
      <modifications>
      </modifications>
      </prefKeys>
      <#if isResidential>
      <contactsEnabled>0</contactsEnabled>
      <#else>
      <contactsEnabled>1</contactsEnabled>
      </#if>
      <commportalToken>${userData.commportalPAT}</commportalToken>
      </provisioning>
      </#escape>